package gov.va.vinci.dart.json;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class PIParticipantInfoView implements Comparable {

	@NotNull
	@Size(min=2,max=512)
	private String name = "";

	@NotNull
	@Size(min=2,max=512)
	private String username = X";

	private boolean checked = false; // notifications
	private boolean dataAccessChecked = false; // data access
	private boolean capriAccessChecked = false; // data access
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = Xsername;
	}

	public boolean isChecked() {
		return checked;
	}

	public void setChecked(boolean checked) {
		this.checked = checked;
	}

	public boolean isDataAccessChecked() {
		return dataAccessChecked;
	}

	public void setDataAccessChecked(boolean dataAccessChecked) {
		this.dataAccessChecked = dataAccessChecked;
	}

	
	@Override
	public int compareTo(Object o) {
		if (o == null) {
			return -1;
		}
		if (PIParticipantInfoView.class.isAssignableFrom(o.getClass()) == false) {
			return -1;
		}
		
		PIParticipantInfoView part2 = (PIParticipantInfoView)o;

//TODO: might want to sort by participant ID (order in which the participant was added to the study)		
		//sort by participant display name
		if (getName() == null) {
			return part2.getName() == null ? 0 : -1;
		}

		return getName().compareTo(part2.getName());
	}

   
    public boolean isCapriAccessChecked() {
        return capriAccessChecked;
    }

    public void setCapriAccessChecked(boolean capriAccessChecked) {
        this.capriAccessChecked = capriAccessChecked;
    }		
}
